unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, Gauges, ComCtrls;

type
  TForm1 = class(TForm)
    Drives: TRadioGroup;
    BitBtn1: TBitBtn;
    Panel1: TPanel;
    Edit1: TEdit;
    Label1: TLabel;
    SpeedButton1: TSpeedButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    BitBtn2: TBitBtn;
    Button1: TButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    Panel2: TPanel;
    SpeedButton4: TSpeedButton;
    Label2: TLabel;
    Edit2: TEdit;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    Panel3: TPanel;
    Label3: TLabel;
    Edit3: TEdit;
    BitBtn3: TBitBtn;
    Memo3: TMemo;
    SpeedButton7: TSpeedButton;
    FindDialog1: TFindDialog;
    BitBtn4: TBitBtn;
    Label4: TLabel;
    Gauge: TGauge;
    Memo2: TRichEdit;
    Memo1: TRichEdit;
    Edit4: TEdit;
    SpeedButton8: TSpeedButton;
    FindDialog2: TFindDialog;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    Gauge1: TGauge;
    procedure FormCreate(Sender: TObject);
    procedure DrivesClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure FindDialog2Find(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure SpeedButton10Click(Sender: TObject);
  private
    { Private declarations }
    FFileName:string;
    function GetDirectoryName(Dir:String):string;
    procedure FindFiles(Apath:string);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  i: integer;
  t: integer;
  c: string;
  Dtype: integer;
  DriveString: string;
  diretorio:string;
  nomedodisco:string;
  diretorioativo:string;
  ocorreu:integer;
  relatorio:string;
  traco:integer;
  quantarquivos:integer;
  conta:integer;

implementation

uses MainFrm, Unit2, Unit3;

{$R *.DFM}
function TForm1.GetDirectoryName(Dir:String):String;
//Funo que formata o nome do diretrio
begin
if Dir[Length(Dir)]<>'\' then
        Result:=Dir+'\'
else
        Result:=Dir;
end;

procedure TForm1.FindFiles(APath:string);
//Procedimento para varrer o disco
var
FsearchRec,
DsearchRec: TSearchRec;
FindResult: integer;

function IsDirNotation(AdirName:String):Boolean;
begin
Result:=(Adirname='.') or (AdirName='..');
end;

begin
APath:=GetDirectoryName(APath);//obtem um nome vlido de diretrio
//CATALOGA OS ARQUIVOS
FindResult:=FindFirst(APath+FFileName,faAnyFile+FaHidden+faSysFile+faReadOnly,fSearchRec);

try
//Continua fazendo a varredura
Memo1.Lines.Add('PASTA:'+LowerCase(Apath));
conta:=conta+1;
if conta>100 then conta:=0;
Gauge1.Progress:=conta;
while FindResult=0 do
begin
if traco=0 then Memo1.Lines.Add('---->'+LowerCase(FsearchRec.Name))
        else Memo1.Lines.Add(LowerCase(FsearchRec.Name));
quantarquivos:=quantarquivos+1;
FindResult:=FindNext(FsearchRec);
end;

//Agora Pesquisa o Subdiretrio
FindResult:=FindFirst(Apath+'*.*',faDirectory,DSearchRec);

while FindResult=0 do
begin
        if ((DSearchRec.Attr and faDirectory) = faDirectory) and not
            IsDirNotation(DSearchRec.Name) then
            begin
            FindFiles(APath+DSearchRec.Name);
            end;
        FindResult:=FindNext(DSearchRec);

end;
Finally
        FindClose(FsearchRec);
        Gauge1.Progress:=0;
end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var S:array[0..MAX_PATH] of char;
begin
traco:=0;
//Determina o diretrio da aplicao
GetCurrentDirectory(Sizeof(S),S);
SaveDialog1.InitialDir:=S;
OpenDialog1.InitialDir:=S;
diretorioativo:=s;
// loop de A..Z para determeinar quais so unidades
// removveis e CD-ROM
for i:=65 to 90 do
        begin
        c:=chr(i)+':\'; //representa um diretrio
        //chama a funo que vai reconhecer a unidade
        //retornando um valor inteiro
        DType:=GetDriveType(PChar(C));
        //baseado no nmero tetornado vai especiaficar quais os
        //drives que interessam catalogar
        if Dtype=DRIVE_REMOVABLE then Drives.Items.Add(C+' - drive removvel');
        if Dtype=DRIVE_CDROM then Drives.Items.Add(C+' - CD-ROM');
        end;
button1.Click;
end;

procedure TForm1.DrivesClick(Sender: TObject);
begin
BitBtn1.Enabled:=true;
Edit1.Text:=Drives.Items.Strings[Drives.ItemIndex];
Diretorio:=Edit1.Text[1]+Edit1.Text[2]+Edit1.Text[3];
Edit1.Text:='Nome do Disco!';
Edit1.SetFocus;
Edit2.Text:='Breve Comentrio';
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
Gauge1.MaxValue:=100;
conta:=0;
memo1.Clear;
if Edit2.Text<>'Breve Comentrio' then
        Memo1.Lines.Add('Contedo: '+Edit2.Text)
        else
        Memo1.Lines.Add('Catalogado pelo Catalog Vr.1.0');
Memo1.Lines.Add('');
Memo1.Lines.Add('----------Diretrio e Arquivos----------');
screen.cursor:=crHourGlass;
BitBtn2.Enabled:=true;
//Depois de colocar o cabealho com o comentrio
//D incio a varredura
try
    FFileName:='*.*';
    FindFiles(diretorio);
finally
screen.Cursor:=crDefault;
Edit1.SetFocus;
end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var nomelido:string;
begin
SpeedButton2.Click;
if Memo1.Lines[1]='' then
        begin
        MessageDlg('No h arquivos gravados!', mtInformation,[mbOk], 0);
        Panel3.Visible:=false;
        end
else begin
SpeedButton8.Enabled:=true;
Memo1.Clear;
OpenDialog1.Execute;
nomelido:=OpenDialog1.FileName;
Memo1.Clear;
Memo1.Lines.LoadFromFile(nomelido);
end;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
Gauge1.Progress:=0;
//Comea a rotina de gravao do arquivo de programao
nomedodisco:=Edit1.text+'.cci';
SaveDialog1.FileName:=nomedodisco;
SaveDialog1.Execute;
    Memo1.Lines.SaveToFile(SaveDialog1.FileName);
//D mensagem de ok para a gravao
MessageDlg('O catlogo deste disco foi gravado corretamente', mtInformation,
      [mbOk], 0);
Button1.Click;
BitBtn1.Enabled:=false;
BitBtn2.Enabled:=false;
Drives.Items.Clear;
// loop de A..Z para determeinar quais so unidades
// removveis e CD-ROM
for i:=65 to 90 do
        begin
        c:=chr(i)+':\'; //representa um diretrio
        //chama a funo que vai reconhecer a unidade
        //retornando um valor inteiro
        DType:=GetDriveType(PChar(C));
        //baseado no nmero tetornado vai especiaficar quais os
        //drives que interessam catalogar
        if Dtype=DRIVE_REMOVABLE then Drives.Items.Add(C+' - drive removvel');
        if Dtype=DRIVE_CDROM then Drives.Items.Add(C+' - CD-ROM');
        end;
Edit1.Text:='';
Edit2.Text:='';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
quantarquivos:=0;
memo1.Clear;
screen.cursor:=crHourGlass;
try
    memo1.Clear;
    FFileName:='*.cci';
    FindFiles(diretorioativo);
finally
screen.Cursor:=crDefault;
end;
Memo1.Lines[0]:=('DISCOS GRAVADOS AT AGORA:');
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
SpeedButton8.Enabled:=false;
SpeedButton9.Enabled:=false;
Button1.Click;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
SpeedButton2.Click;
SpeedButton8.Enabled:=false;
SpeedButton9.Enabled:=false;
BitBtn3.Enabled:=true;
BitBtn4.Enabled:=false;
Gauge.Progress:=0;
Gauge.MaxValue:=quantarquivos;
traco:=1;
Edit3.Text:='';
Memo2.Clear;
Memo3.Clear;
button1.Click;
if Memo1.Lines[1]='' then
        begin
        MessageDlg('No h arquivos gravados!', mtInformation,[mbOk], 0);
        Panel3.Visible:=false;
        end
else begin
Panel3.Visible:=true;
memo1.Clear;
screen.cursor:=crHourGlass;
try
    memo1.Clear;
    FFileName:='*.cci';
    FindFiles(diretorioativo);
finally
screen.Cursor:=crDefault;
end;
//Aqui j sabe quais so os arquivos que vo ser rastreados
Edit3.SetFocus;
Memo3.Lines:=Memo1.Lines;
Memo3.Lines[0]:='----->';
//clocar aqui a rotina que vai tirar os ---
traco:=0;
button1.Click;
end;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
Close;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
SpeedButton8.Enabled:=false;
SpeedButton9.Enabled:=false;
Drives.Items.Clear;
// loop de A..Z para determeinar quais so unidades
// removveis e CD-ROM
for i:=65 to 90 do
        begin
        c:=chr(i)+':\'; //representa um diretrio
        //chama a funo que vai reconhecer a unidade
        //retornando um valor inteiro
        DType:=GetDriveType(PChar(C));
        //baseado no nmero tetornado vai especiaficar quais os
        //drives que interessam catalogar
        if Dtype=DRIVE_REMOVABLE then Drives.Items.Add(C+' - drive removvel');
        if Dtype=DRIVE_CDROM then Drives.Items.Add(C+' - CD-ROM');
        end;
Edit1.Text:='';
Edit2.Text:='';
Button1.Click;
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
Form2.ShowModal;
end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
begin
Panel3.Visible:=false;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
var
nomeprocura:string;
palavra:string;
i:integer;
t:integer;
arquivo:string;
begin
BitBtn4.Enabled:=true;
BitBtn3.Enabled:=false;
t:=0;
i:=1;
relatorio:='';
arquivo:=Memo3.Lines[i];
while arquivo<>'' do
        begin
        nomeprocura:=diretorioativo+'\'+arquivo;
        OpenDialog1.FileName:=nomeprocura;
        Memo2.Clear;
        Memo2.Lines.LoadFromFile(nomeprocura);
        ocorreu:=0; //zera o nmero de ocorrncias
        with Memo2 do
                begin
                FindDialog1.Position:=Point(Memo2.Left,Memo2.Top);
                palavra:=Edit3.Text;
                FindDialog1.FindText:=palavra;
                FindDialog1Find(FindDialog1);
                end;
        t:=t+1;
        gauge.Progress:=t;
        relatorio:=relatorio+arquivo+'--->'+inttostr(ocorreu)+' ocorrncias '+Chr(10);
        i:=i+1;
        arquivo:=Memo3.Lines[i];
        end;
Memo2.Clear;
Memo2.Lines.Add('Pesquisa para:'+palavra);
Memo2.Lines.Add(' ');
Memo2.Lines.Add(relatorio);
Memo2.Lines.Add('-----x-----');




end;



procedure TForm1.FindDialog1Find(Sender: TObject);
var
  I, J, PosReturn, SkipChars: Integer;
begin
  for I := 0 to Memo2.Lines.Count do
  begin
    PosReturn := Pos(FindDialog1.FindText,Memo2.Lines[I]);
    if PosReturn <> 0 then //achou!
    begin
      ocorreu:=ocorreu+1;
      Skipchars := 0;
      for J := 0 to I - 1 do
      Skipchars := Skipchars + Length(Memo2.Lines[J]);
      SkipChars := SkipChars + (I*2);
      SkipChars := SkipChars + PosReturn - 1;
      Memo2.SetFocus;
      Memo2.SelStart := SkipChars;
      Memo2.SelLength := Length(FindDialog1.FindText);
    end;
  end;
end;


procedure TForm1.BitBtn4Click(Sender: TObject);
begin
BitBtn3.Enabled:=true;
SpeedButton3.Click;
end;

procedure TForm1.SpeedButton8Click(Sender: TObject);
var palavra2:string;
begin
SpeedButton9.Enabled:=true;
t:=0;
FindDialog2.Position:=Point(Memo1.Left,Memo1.Top);
palavra2:=Edit4.Text;
FindDialog2.FindText:=palavra2;
FindDialog2Find(FindDialog2);
end;

procedure TForm1.FindDialog2Find(Sender: TObject);
var
  I, J, PosReturn, SkipChars: Integer;
begin
  for I := T to Memo1.Lines.Count do
  begin
    PosReturn := Pos(FindDialog2.FindText,Memo1.Lines[I]);
    if PosReturn <> 0 then //achou!
    begin
      Skipchars := 0;
      for J := 0 to I - 1 do
      Skipchars := Skipchars + Length(Memo1.Lines[J]);
      SkipChars := SkipChars + (I*2);
      SkipChars := SkipChars + PosReturn - 1;
      Memo1.SetFocus;
      Memo1.SelStart := SkipChars;
      Memo1.SelLength := Length(FindDialog2.FindText);
      Break;
    end;
    t:=t+1;
  end;
end;

procedure TForm1.SpeedButton9Click(Sender: TObject);
begin
t:=t+1;
FindDialog2Find(FindDialog2);
end;

procedure TForm1.SpeedButton10Click(Sender: TObject);
begin
SpeedButton2.Click;
if Memo1.Lines[1]='' then
        begin
        MessageDlg('No h arquivos gravados!', mtInformation,[mbOk], 0);
        Panel3.Visible:=false;
        end
else Begin
     Form3.FileListBox1.Update;
     Form3.ShowModal;
     end;
end;

end.
